'1-Wire Serial Number Search - Multiple Devices Attached.
'Code by Jman 04 April 2016
Option Explicit 
Dim A%, PinNbr 
Dim id_bit, cmp_id_bit, LastDeviceFlag, Last_zero 
Dim search_direction, id_bit_number, LastDiscrepancy 
Dim DeviceCount, ROM_NO(8) 
Dim LastFamilyDiscrepancy, I, J 
PinNbr = 15

'=================================================================== 
Device_loop:  'Device loop: loop for all devices on the bus 
OneWire Reset Pinnbr 

If LastDeviceFlag = 1 Then Print "--Done--": End 
id_bit_number = 1 
last_zero = 0 

OneWire Write PinNbr,1,1,&HF0 'Send the Search ROM command (FO) 

'=================================================================== 
Check_bit: 
OneWire Read PinNbr, 4 , 2, id_bit, cmp_id_bit 'Get response from device 

If (id_bit = 1 And cmp_id_bit = 1) Then GoTo No_device 
If Not ((id_bit = 0) And (cmp_id_bit = 0)) Then 
 search_direction = id_bit 
 I=Fix(((id_bit_number)-1)/8) 
 Rom_NO(I) = Rom_NO(I) << 1 
 ROM_NO(I) = Rom_no(I)+search_direction 
EndIf 

If ((id_bit = 0) And (cmp_id_bit = 0)) Then GoSub conflict 

OneWire Write PinNbr,4,1,search_direction ' send 1 or 0 as search direction 
id_bit_number = id_bit_number+1 ' incredement id_bit_number 

If id_bit_number <= 64 Then GoTo Check_bit    'Check for next bit 
If id_bit_number > 64 Then LastDiscrepancy = last_zero 
If LastDiscrepancy = 0 Then LastDeviceFlag = 1 

For i= 0 To 7 
 A%=Rom_no(I) 
 Rom_No(I) = ((A% * &h202020202) And &h10884422010) Mod 1023     'Thanks Rob 
Next I 

Print "Family ";Hex$(ROM_NO(0),2);"H" 
Print "ID:", Hex$(ROM_NO(1),2),Hex$(ROM_NO(2),2),Hex$(ROM_NO(3),2),Hex$(ROM_NO(4),2),Hex$(ROM_NO(5),2),Hex$(ROM_NO(6),2) 
Print "CRC:", Hex$(ROM_NO(7),2) 
Print 
deviceCount = deviceCount + 1 

For J=0 To 7 
 Rom_no(J)=0 
Next J 

If LastDeviceFlag = 0 Then GoTo Device_loop 
Print "DeviceCount";deviceCount, " device(s)." 
Print "--Done--":End 

'=================================================================== 
NO_device:  'Since both response bits are 11, there are no devices 
 Print " No devices present" 
End 

'=================================================================== 
Conflict:     'id_bit_number = LastDiscrepancy then take "1" path 
If (id_bit_number) = LastDiscrepancy Then 
 search_direction = 1 
 I=Fix(((id_bit_number)-1)/8) 
 Rom_NO(I) = Rom_NO(I) << 1 
 Rom_NO(I) = Rom_NO(I)+search_direction 
EndIf 

'id_bit_number > LastDiscrepancy then take the "0" path 
If (id_bit_number > LastDiscrepancy) Then 
 search_direction = 0 
 I=Fix(((id_bit_number)-1)/8) 
 Rom_NO(I) = Rom_NO(I) << 1 
 ROM_NO(I) = ROM_NO(I)+search_direction 
 Rom_NO(I) = Rom_NO(I)+search_direction 
 GoSub Family 
EndIf 

' id_bit_number < LastDiscrepancy then take same path as last time 
If (id_bit_number < LastDiscrepancy) Then 
 I=Fix(((id_bit_number)-1)/8) 
 search_direction = ROM_NO(I) 
 If search_direction = 0 Then GoSub Family 
EndIf 

Return 
'=================================================================== 
Family:             'LastFamilyDiscrepancy bit index set 
Last_zero = id_bit_number 
If last_zero <9 Then 
 LastFamilyDiscrepancy = last_zero 
EndIf 

Return 
'=================================================================== 
